/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Util;

public class HTTPURL {
    private HTTPURL() {
    }

    public static String getHTTPStatusCode(int status) {
        switch (status) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 306: {
                return "(Unused)";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return Integer.toString(status, 10);
    }

    public static URL getURL(String url) throws IOException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            if (url.indexOf("://") == -1) {
                return new URL("http://" + url);
            }
            throw (IOException)e.fillInStackTrace();
        }
    }

    public static URL getURL(URL base, String url) throws MalformedURLException {
        return new URL(base, url);
    }

    private static URLConnection getConnection(URL url, int count) throws IOException {
        return HTTPURL.getConnection(url, count, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URLConnection getConnection(URL url, int count, ApplContext ac) throws IOException {
        String protocol;
        if (count > 5) {
            throw new ProtocolException("Server redirected too many times (5)");
        }
        if (Util.servlet && !"https".equalsIgnoreCase(protocol = url.getProtocol()) && !"http".equalsIgnoreCase(protocol)) {
            System.err.println("[WARNING] : someone is trying to get the file: " + url);
            throw new FileNotFoundException("import " + url + ": Operation not permitted");
        }
        URLConnection urlC = url.openConnection();
        if (Util.onDebug) {
            System.err.println("Accessing " + url);
            if (ac.getCredential() != null) {
                System.err.println("with [" + ac.getCredential() + ']');
            }
        }
        urlC.setRequestProperty("Pragma", "no-cache");
        urlC.setRequestProperty("Cache-Control", "no-cache, no-store");
        urlC.setRequestProperty("User-Agent", "Jigsaw/2.2.5 W3C_CSS_Validator_JFouffa/2.0");
        if (ac.getCredential() != null) {
            urlC.setRequestProperty("Authorization", ac.getCredential());
        }
        if (ac.getLang() != null) {
            if (ac.getLang().indexOf(42) == -1) {
                urlC.setRequestProperty("Accept-Language", ac.getLang() + ",*");
            } else {
                urlC.setRequestProperty("Accept-Language", ac.getLang());
            }
        }
        urlC.setRequestProperty("Accept", "text/css,text/html,text/xml,application/xhtml+xml,application/xml,image/svg+xml,*/*;q=0.1");
        urlC.connect();
        if (urlC instanceof HttpURLConnection) {
            int status;
            HttpURLConnection httpURL = (HttpURLConnection)urlC;
            try {
                status = httpURL.getResponseCode();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new FileNotFoundException(url + ": " + HTTPURL.getHTTPStatusCode(404));
            }
            switch (status) {
                case 200: {
                    break;
                }
                case 301: 
                case 302: {
                    try {
                        URL u = HTTPURL.getURL(httpURL.getHeaderField("Location"));
                        URLConnection uRLConnection = HTTPURL.getConnection(u, count + 1, ac);
                        return uRLConnection;
                    }
                    finally {
                        httpURL.disconnect();
                    }
                }
                case 401: {
                    String realm = httpURL.getHeaderField("WWW-Authenticate");
                    httpURL.disconnect();
                    if (realm != null) {
                        throw new ProtocolException(realm);
                    }
                }
                default: {
                    try {
                        if (httpURL.getResponseMessage() != null) {
                            throw new FileNotFoundException(url + ": " + httpURL.getResponseMessage());
                        }
                        throw new FileNotFoundException(url + ": " + HTTPURL.getHTTPStatusCode(status));
                    }
                    catch (Throwable throwable) {
                        httpURL.disconnect();
                        throw throwable;
                    }
                }
            }
        }
        return urlC;
    }

    public static URLConnection getConnection(URL url) throws IOException {
        return HTTPURL.getConnection(url, 0);
    }

    public static URLConnection getConnection(URL url, ApplContext ac) throws IOException {
        return HTTPURL.getConnection(url, 0, ac);
    }

    public static InputStream getInputStream(URLConnection uco) throws IOException {
        InputStream orig_stream = uco.getInputStream();
        if (orig_stream == null) {
            return orig_stream;
        }
        String encoding = uco.getContentEncoding();
        if (encoding == null) {
            return orig_stream;
        }
        if (encoding.equalsIgnoreCase("gzip")) {
            return new GZIPInputStream(orig_stream);
        }
        return orig_stream;
    }

    public static void main(String[] args) throws Exception {
        int c;
        InputStream in = HTTPURL.getConnection(HTTPURL.getURL(args[0])).getInputStream();
        while ((c = in.read()) != -1) {
            System.err.print((char)c);
        }
        System.exit(0);
    }
}

